<?php
/**
 * Dashboard principal después del login
 * Sistema de Parking - Viewnext
 */

session_start();

// Verificar si el usuario está logueado
if (!isset($_SESSION['usuario_logueado']) || $_SESSION['usuario_logueado'] !== true) {
    header('Location: login_register.html');
    exit();
}

// Verificar timeout de sesión (opcional - 30 minutos)
$timeout_duration = 1800; // 30 minutos en segundos
if (isset($_SESSION['login_time']) && (time() - $_SESSION['login_time']) > $timeout_duration) {
    // Sesión expirada
    session_destroy();
    header('Location: login_register.html?error=session_expired');
    exit();
}

// Actualizar tiempo de última actividad
$_SESSION['login_time'] = time();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Sistema de Parking Viewnext</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Arial', sans-serif;
            background: #212121;
            min-height: 100vh;
            padding: 15px;
            color: white;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            gap: 25px;
        }

        .header {
            background: transparent;
            padding: 25px 30px;
            width: 100%;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transform-style: preserve-3d;
            transition: all 0.3s ease;
        }

        .welcome {
            color: white;
            font-size: 22px;
            font-weight: 600;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.5);
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .user-name {
            color: #ccc;
            font-weight: 500;
            font-size: 14px;
        }

        .logout-btn {
            background-color: #212121;
            color: white;
            padding: 10px 20px;
            border: 2px solid #212121;
            border-radius: 8px;
            cursor: pointer;
            text-decoration: none;
            font-weight: bold;
            font-size: 14px;
            transition: all 0.35s ease;
            box-shadow: 6px 6px 10px rgba(0,0,0,1),
                        1px 1px 10px rgba(255, 255, 255, 0.1);
        }

        .logout-btn:hover {
            transform: translateY(-2px);
            box-shadow: 8px 8px 15px rgba(0,0,0,1),
                        2px 2px 15px rgba(255, 255, 255, 0.15);
        }

        .dashboard-content {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 25px;
            width: 100%;
            margin-bottom: 25px;
        }

        .card {
            background-color: #2a2a2a;
            padding: 25px;
            border-radius: 15px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            gap: 15px;
            transform-style: preserve-3d;
            transition: all 0.5s ease;
            box-shadow: inset 2px 2px 10px rgba(0,0,0,1),
                        inset -1px -1px 5px rgba(255, 255, 255, 0.1);
        }

        .card:hover {
            transform: translateY(-3px);
            box-shadow: inset 2px 2px 10px rgba(0,0,0,1),
                        inset -1px -1px 5px rgba(255, 255, 255, 0.1),
                        0 10px 25px rgba(0,0,0,0.6);
        }

        .card h3 {
            color: white;
            font-size: 18px;
            font-weight: 600;
            text-align: center;
            margin-bottom: 10px;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.5);
        }

        .card-acciones {
            background: transparent;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 25px;
            gap: 15px;
        }

        .user-info {
            background-color: #1f1f1f;
            padding: 20px;
            border-radius: 10px;
            width: 100%;
            box-shadow: inset 3px 3px 8px rgba(0,0,0,0.8),
                        inset -1px -1px 3px rgba(255, 255, 255, 0.05);
        }

        .user-info p {
            margin: 10px 0;
            color: #ccc;
            font-size: 13px;
            display: flex;
            align-items: center;
            flex-wrap: wrap;
        }

        .user-info strong {
            color: white;
            display: inline-block;
            min-width: 100px;
            font-weight: 600;
            margin-right: 10px;
        }

        .quick-actions {
            display: flex;
            flex-direction: column;
            gap: 15px;
            width: 100%;
            align-items: center;
        }

        .action-btn {
            background-color: #212121;
            color: white;
            padding: 12px 25px;
            border: 2px solid #212121;
            border-radius: 8px;
            cursor: pointer;
            text-decoration: none;
            text-align: center;
            font-weight: bold;
            font-size: 14px;
            transition: all 0.35s ease;
            display: block;
            width: 100%;
            max-width: 250px;
            box-shadow: 6px 6px 10px rgba(0,0,0,1),
                        1px 1px 10px rgba(255, 255, 255, 0.1);
        }

        .action-btn:hover {
            transform: translateY(-2px);
            box-shadow: 8px 8px 15px rgba(0,0,0,1),
                        2px 2px 15px rgba(255, 255, 255, 0.15);
        }

        .parking-status {
            grid-column: 1 / -1;
            background-color: #2a2a2a;
            padding: 25px;
            border-radius: 15px;
            transform-style: preserve-3d;
            transition: all 0.5s ease;
            box-shadow: inset 2px 2px 10px rgba(0,0,0,1),
                        inset -1px -1px 5px rgba(255, 255, 255, 0.1);
        }

        .parking-status:hover {
            transform: translateY(-3px);
            box-shadow: inset 2px 2px 10px rgba(0,0,0,1),
                        inset -1px -1px 5px rgba(255, 255, 255, 0.1),
                        0 10px 25px rgba(0,0,0,0.6);
        }

        .parking-status h3 {
            color: white;
            font-size: 18px;
            font-weight: 600;
            text-align: center;
            margin-bottom: 15px;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.5);
        }

        .status-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 15px;
            margin-top: 15px;
        }

        .status-item {
            background-color: #1f1f1f;
            padding: 20px;
            border-radius: 10px;
            text-align: center;
            transition: all 0.3s ease;
            box-shadow: inset 3px 3px 8px rgba(0,0,0,0.8),
                        inset -1px -1px 3px rgba(255, 255, 255, 0.05);
        }

        .status-item:hover {
            transform: translateY(-2px) scale(1.02);
            box-shadow: inset 3px 3px 8px rgba(0,0,0,0.8),
                        inset -1px -1px 3px rgba(255, 255, 255, 0.05),
                        0 8px 15px rgba(0,0,0,0.5);
        }

        .status-number {
            font-size: 24px;
            font-weight: bold;
            color: #4CAF50;
            margin-bottom: 8px;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.5);
        }

        .status-label {
            color: #ccc;
            font-size: 12px;
            font-weight: 500;
        }

        /* TABLET - 768px a 1024px */
        @media (max-width: 1024px) and (min-width: 769px) {
            .container {
                padding: 20px;
                gap: 20px;
            }

            .header {
                padding: 20px;
            }

            .welcome {
                font-size: 20px;
            }

            .card, .card-acciones {
                padding: 20px;
            }

            .status-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        /* MÓVIL - hasta 768px */
        @media (max-width: 768px) {
            body {
                padding: 10px;
            }

            .container {
                gap: 15px;
            }

            .dashboard-content {
                grid-template-columns: 1fr;
                gap: 15px;
            }
            
            .header {
                flex-direction: column;
                gap: 15px;
                text-align: center;
                padding: 20px 15px;
            }
            
            .user-menu {
                flex-direction: column;
                gap: 10px;
                width: 100%;
                align-items: center;
            }

            .user-name {
                font-size: 13px;
                text-align: center;
            }

            .logout-btn {
                padding: 8px 16px;
                font-size: 13px;
                width: auto;
                min-width: 120px;
            }

            .welcome {
                font-size: 18px;
                text-align: center;
                line-height: 1.3;
            }

            .card, .card-acciones {
                padding: 20px 15px;
                margin-bottom: 0;
            }

            .card h3 {
                font-size: 16px;
                margin-bottom: 8px;
            }

            .user-info {
                padding: 15px;
            }

            .user-info p {
                font-size: 12px;
                margin: 8px 0;
                flex-direction: column;
                align-items: flex-start;
                text-align: left;
            }

            .user-info strong {
                min-width: auto;
                margin-right: 0;
                margin-bottom: 2px;
                font-size: 12px;
            }

            .action-btn {
                padding: 10px 20px;
                font-size: 13px;
                max-width: 200px;
            }

            .parking-status {
                padding: 20px 15px;
            }

            .parking-status h3 {
                font-size: 16px;
                margin-bottom: 12px;
            }

            .status-grid {
                grid-template-columns: 1fr 1fr;
                gap: 10px;
            }

            .status-item {
                padding: 15px 10px;
            }

            .status-number {
                font-size: 20px;
                margin-bottom: 5px;
            }

            .status-label {
                font-size: 11px;
            }
        }

        /* MÓVIL PEQUEÑO - hasta 480px */
        @media (max-width: 480px) {
            body {
                padding: 8px;
            }

            .container {
                gap: 12px;
            }

            .header {
                padding: 15px 10px;
            }

            .welcome {
                font-size: 16px;
                word-break: break-word;
            }

            .user-name {
                font-size: 12px;
                word-break: break-word;
            }

            .logout-btn {
                padding: 6px 12px;
                font-size: 12px;
                min-width: 100px;
            }

            .card, .card-acciones {
                padding: 15px 10px;
            }

            .card h3 {
                font-size: 15px;
            }

            .user-info {
                padding: 12px;
            }

            .user-info p {
                font-size: 11px;
                margin: 6px 0;
            }

            .user-info strong {
                font-size: 11px;
            }

            .action-btn {
                padding: 8px 15px;
                font-size: 12px;
                max-width: 180px;
            }

            .parking-status {
                padding: 15px 10px;
            }

            .parking-status h3 {
                font-size: 15px;
            }

            .status-grid {
                gap: 8px;
            }

            .status-item {
                padding: 12px 8px;
            }

            .status-number {
                font-size: 18px;
            }

            .status-label {
                font-size: 10px;
            }
        }

        /* Animaciones */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .card, .header, .card-acciones, .parking-status {
            animation: fadeInUp 0.6s ease-out;
        }

        .card:nth-child(2) {
            animation-delay: 0.1s;
        }

        .card:nth-child(3) {
            animation-delay: 0.2s;
        }

        .parking-status {
            animation-delay: 0.3s;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1 class="welcome">Sistema de Parking - Viewnext</h1>
            <div class="user-menu">
                <span class="user-name">
                    <?php echo htmlspecialchars($_SESSION['usuario_nombre'] . ' ' . $_SESSION['usuario_apellidos']); ?>
                </span>
                <a href="logout.php" class="logout-btn">Cerrar Sesión</a>
            </div>
        </div>

        <div class="dashboard-content">
            <div class="card">
                <h3>Información Personal</h3>
                <div class="user-info">
                    <p><strong>Nombre:</strong> <?php echo htmlspecialchars($_SESSION['usuario_nombre']); ?></p>
                    <p><strong>Apellidos:</strong> <?php echo htmlspecialchars($_SESSION['usuario_apellidos']); ?></p>
                    <p><strong>Email:</strong> <?php echo htmlspecialchars($_SESSION['usuario_email']); ?></p>
                    <p><strong>Matrícula 1:</strong> <?php echo htmlspecialchars($_SESSION['usuario_matricula1']); ?></p>
                    <?php if (!empty($_SESSION['usuario_matricula2'])): ?>
                        <p><strong>Matrícula 2:</strong> <?php echo htmlspecialchars($_SESSION['usuario_matricula2']); ?></p>
                    <?php endif; ?>
                </div>
            </div>

            <div class="card-acciones">
                <div class="quick-actions">
                    <a href="mapa.php" class="action-btn">Reservar Plaza</a>
            </div>
            <div class="quick-actions">
                    <a href="#" class="action-btn">Editar Perfil</a>
            </div>
        </div>
    </div>

    <script>
        // Alerta de sesión próxima a expirar (25 minutos)
        setTimeout(function() {
            if (confirm('Tu sesión expirará en 5 minutos. ¿Deseas continuar?')) {
                // Recargar página para extender sesión
                window.location.reload();
            }
        }, 25 * 60 * 1000); // 25 minutos

        // Auto-logout por inactividad (30 minutos)
        setTimeout(function() {
            alert('Tu sesión ha expirado por inactividad.');
            window.location.href = 'logout.php';
        }, 30 * 60 * 1000); // 30 minutos
    </script>
</body>
</html>